﻿<#-------------------------------------------------------------------------------------
Script: create login.ps1
Author: Amy Herold
Date: 12 June 2014
Purpose: Add set of logins to specified server; Add to database and role.

- Revisions to be considered - 
sql server version check?
logins need to be the truncated value of 20 char or less - logic to truncate?
error handling - login already exists or user exists at the database? 
error handling - there is no such AD login?
param for role?


WARNING: RUN THIS AT YOUR OWN RISK!!! NO WARRANTY OR GUARANTEE PROVIDED!!!

--------------------------------------------------------------------------------------#>
Import-Module sqlps;


$login_array = New-Object System.Collections.ArrayList
$server_array = New-Object System.Collections.ArrayList
$login_array.Clear();
$server_array.Clear();
$users = '';
$servers = '';

#------------------------------------params to pass in - update these-------------------------------------
#-----------------these need to be the abbreviated values...or logic can be written for this--------------
$users = @('EmmetBrickowski P@ssword1 S'
,'PresBusiness P@ssword1 S'
,'Wyldstyle P@ssword1 S'
,'Unikitty P@ssword1 S'
,'BadCop P@ssword1 S'
,'Vitruvius P@ssword1 S')

$servers = @('SERVER_A\SQLSERVER2012','SERVER_A');


#-------------------------------------let's look at arrays for a second-----------------------------------
    #-------------add servers to an array-----------    
    foreach($item in $servers)
    {
        $server_array.Add(@($item.Split("\"))) | out-null;
    }

    #-------add the login list to an array----------
    foreach($loginpass in $users)
    {
        $login_array.Add(@($loginpass.Split(" "))) | out-null;
    }


       <#----
    #----------out put the servers and instances-------------
    for ($i = 0;$i -lt ($server_array | Measure-Object).count;$i++)
    {
    
        #----------get the sql server instance name-------------
        if ($server_array[$i][1] -eq $null)
        {
            $instance = "DEFAULT"
        }
        else
        {
            $instance = $server_array[$i][1]   
        }

        Write-Host $server_array[$i][0]'       '$instance
        
    }

    ---#>

    <#---

    for ($i = 0;$i -lt ($login_array | Measure-Object).count;$i++)
    {
        #Write-Host $login_array[$i][1], $login_array[$i][0], $login_array[$i][3], $login_array[$i][2]

        Write-Host $login_array[$i][0]

        Write-Host $login_array[$i][1]

        Write-Host $login_array[$i][2]

    }
    

    for ($i = 0;$i -lt ($login_array | Measure-Object).count;$i++)
    {
        Write-Host $login_array[$i][0]
    }


    for ($i = 0;$i -lt ($login_array | Measure-Object).count;$i++)
    {
        Write-Host $login_array[$i][1]
    }


    for ($i = 0;$i -lt ($login_array | Measure-Object).count;$i++)
    {
        Write-Host $login_array[$i][2]
    }

---#>

for ($i = 0;$i -lt ($server_array | Measure-Object).count;$i++)
{
    
    #----------get the sql server instance name-------------
    if ($server_array[$i][1] -eq $null)
    {
        $instance = "DEFAULT"
    }
    else
    {
        $instance = $server_array[$i][1]   
    }       
    
     
    $server_root = 'SQLSERVER:\sql\'+$server_array[$i][0];
    $location1 = $server_array[$i][0]+':\'+$instance+'\Databases\';
    #$location2 = $location1+$database;


    #-------------------------------------------begin update--------------------------------------------------


    #Get-PSDrive;

    New-PSDrive -Name $server_array[$i][0] -Root $server_root -PSProvider SqlServer;
    Set-Location $location1;

    
    $note =  "**************CREATING LOGINS ON "+$server_array[$i][0]+"\"+$instance+"******************";
    $note;

    for ($ii = 0;$ii -lt ($login_array | Measure-Object).count;$ii++)
    {

        if ($login_array[$ii][2] -eq 'W')
        {
            $create_login = 'IF NOT EXISTS(SELECT * FROM sys.syslogins WHERE name = '''+$login_array[$ii][0]+''') CREATE LOGIN ['+$login_array[$ii][0]+'] FROM WINDOWS WITH DEFAULT_DATABASE=[master]';
        }
        
        if ($login_array[$ii][2] -eq 'S')
        {
            $create_login = 'IF NOT EXISTS(SELECT * FROM sys.syslogins WHERE name = '''+$login_array[$ii][0]+''') CREATE LOGIN ['+$login_array[$ii][0]+'] WITH PASSWORD=N'''+$login_array[$ii][1]+''', DEFAULT_DATABASE=[master], CHECK_EXPIRATION=OFF, CHECK_POLICY=ON;';
        }

        $create_login
        #Invoke-Sqlcmd $create_login;
        Invoke-Sqlcmd $create_login -SuppressProviderContextWarning;
    }

    #change location and drop the drive
    Set-Location c:\;
    Remove-PSDrive -Name $server_array[$i][0];
    
}

#------------------------------------------- end update----------------------------------------------------





